# Guía de Instalación - User Profile Block (Light)

Esta guía te ayudará a integrar el bloque User Profile en tu proyecto Laravel 12.

## 📋 Requisitos Previos

- Laravel 12.x instalado
- PHP 8.3 o superior
- Tailwind CSS configurado en tu proyecto
- Sistema de autenticación configurado
- Tabla `users` existente en la base de datos
- Layout principal (`resources/views/layouts/app.blade.php`) disponible

## 🚀 Pasos de Instalación

### Paso 1: Extraer el contenido

**Importante:** Descomprime el archivo ZIP en la **raíz de tu proyecto Laravel** (donde están las carpetas `app/`, `config/`, `routes/`, `bootstrap/`, etc.).

Al descomprimir el ZIP, la estructura de archivos quedará así:

```
tu-proyecto-laravel/
├── app/
│   └── Blocks/
│       └── UserProfile/              ← El bloque queda aquí
│           ├── Controllers/
│           ├── Requests/
│           ├── Services/
│           ├── Views/
│           ├── routes.php
│           └── UserProfileServiceProvider.php
├── README.md
├── LICENSE.txt
└── docs/
    └── INSTALLATION.md
```

**Nota:** Asegúrate de descomprimir el ZIP en la raíz del proyecto, no dentro de una subcarpeta. Los archivos deben quedar directamente en las carpetas `app/`, etc.

### Paso 2: Registrar el Service Provider

Abre el archivo `bootstrap/providers.php` y añade el Service Provider del bloque:

```php
<?php

return [
    App\Providers\AppServiceProvider::class,
    App\Blocks\UserProfile\UserProfileServiceProvider::class, // ← Añadir esta línea
];
```

### Paso 3: Verificar el layout principal

El bloque asume que tienes un layout principal en `resources/views/layouts/app.blade.php`. Si tu layout tiene otro nombre o ubicación, necesitarás:

1. Crear el layout, o
2. Modificar las vistas del bloque para usar tu layout

### Paso 4: Limpiar caché

```bash
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

## ✅ Verificación

Para verificar que todo funciona correctamente:

1. **Verifica las rutas:**
   ```bash
   php artisan route:list | grep profile
   ```
   Deberías ver las rutas:
   - `GET /profile` - user-profile.show
   - `PUT /profile` - user-profile.update
   - `PUT /profile/password` - user-profile.password.update

2. **Accede al perfil:**
   - Inicia sesión en tu aplicación
   - Accede a `/profile`
   - Deberías ver el formulario de perfil

3. **Prueba la edición:**
   - Actualiza tu nombre o email
   - Guarda los cambios
   - Deberías ver un mensaje de éxito

4. **Prueba el cambio de contraseña:**
   - Completa el formulario de cambio de contraseña
   - Guarda los cambios
   - Deberías poder iniciar sesión con la nueva contraseña

## 🔧 Solución de Problemas

### Error: "View [user-profile-block::profile.show] not found"

1. **Verifica que el Service Provider esté registrado:**
   Revisa `bootstrap/providers.php`.

2. **Limpia el cache:**
   ```bash
   php artisan view:clear
   php artisan config:clear
   ```

3. **Verifica la estructura de directorios:**
   ```bash
   ls -la app/Blocks/UserProfile/Views/profile/show.blade.php
   ```

### Error: "Route [user-profile.show] not defined"

1. **Verifica que el Service Provider esté registrado:**
   El Service Provider es quien carga las rutas.

2. **Limpia el cache de rutas:**
   ```bash
   php artisan route:clear
   ```

3. **Verifica el archivo de rutas:**
   ```bash
   cat app/Blocks/UserProfile/routes.php
   ```

### El layout no se encuentra

Si tu layout tiene otro nombre o ubicación, puedes:

1. **Crear el layout estándar:**
   Crea `resources/views/layouts/app.blade.php` si no existe.

2. **Modificar las vistas:**
   Cambia `@extends('layouts.app')` por `@extends('tu-layout')` en:
   - `app/Blocks/UserProfile/Views/profile/show.blade.php`

### Los estilos no se aplican

1. **Verifica que Tailwind CSS esté configurado correctamente**

2. **Asegúrate de compilar los assets:**
   ```bash
   npm run build
   # o
   npm run dev
   ```

### Error de validación de email único

El bloque valida que el email sea único excepto para el usuario actual. Si ves errores relacionados, verifica que la tabla `users` tenga el campo `email` correctamente configurado.

## 📝 Uso Básico

### Agregar enlace al menú

Agrega un enlace en tu navbar o menú de usuario:

```blade
@auth
    <a href="{{ route('user-profile.show') }}" class="...">
        Mi Perfil
    </a>
@endauth
```

### Acceder programáticamente

```php
use Illuminate\Support\Facades\Route;

// En un controlador
return redirect()->route('user-profile.show');
```

## 🎨 Personalización

### Cambiar las rutas

Edita `app/Blocks/UserProfile/routes.php`:

```php
Route::middleware(['web', 'auth'])->prefix('mi-perfil')->group(function () {
    // ...
});
```

### Personalizar las vistas

Las vistas están en `app/Blocks/UserProfile/Views/`. Puedes modificarlas directamente:

- `Views/profile/show.blade.php` - Vista principal del perfil
- `Views/components/input.blade.php` - Componente de input
- `Views/components/button.blade.php` - Componente de botón

### Agregar campos adicionales

Para agregar campos adicionales (ej: teléfono, dirección):

1. **Agregar el campo en la migración de users** (si no existe)

2. **Actualizar el Form Request:**
   Edita `app/Blocks/UserProfile/Requests/UpdateProfileRequest.php`

3. **Actualizar el Service:**
   Edita `app/Blocks/UserProfile/Services/UserProfileService.php`

4. **Actualizar la vista:**
   Edita `app/Blocks/UserProfile/Views/profile/show.blade.php`

## 📚 Documentación Adicional

Para más información, consulta:
- `README.md` - Documentación completa del bloque
- `LICENSE.txt` - Términos de licencia

## 🎯 Próximos Pasos

Una vez instalado el bloque:

1. Agrega un enlace al perfil en tu navbar o menú
2. Personaliza las vistas según tus necesidades
3. Opcionalmente, agrega campos adicionales al perfil
4. ¡Disfruta de un sistema de perfil de usuario elegante!

---

**¿Necesitas ayuda?** Consulta la documentación de Laravel sobre [autenticación](https://laravel.com/docs/authentication) y [validación](https://laravel.com/docs/validation).
