<?php

use App\Blocks\UserProfile\Controllers\UserProfileController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| User Profile Block Routes
|--------------------------------------------------------------------------
|
| These routes are loaded by the UserProfileServiceProvider and are isolated
| to the user profile block namespace.
|
*/

Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/profile', [UserProfileController::class, 'show'])->name('user-profile.show');
    Route::put('/profile', [UserProfileController::class, 'updateProfile'])->name('user-profile.update');
    Route::put('/profile/password', [UserProfileController::class, 'updatePassword'])->name('user-profile.password.update');
});
