@extends('layouts.app')

@section('title', 'Mi Perfil')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="mb-8">
        <h1 class="text-3xl md:text-4xl font-bold text-[#1b1b18] dark:text-[#EDEDEC] mb-2">
            Mi Perfil
        </h1>
        <p class="text-[#706f6c] dark:text-[#A1A09A]">
            Gestiona tu información personal y configuración de cuenta.
        </p>
    </div>

    <div class="space-y-6">
        <!-- Update Profile Information -->
        <div class="bg-white dark:bg-[#161615] border border-[#e3e3e0] dark:border-[#3E3E3A] rounded-xl shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-[#e3e3e0] dark:border-[#3E3E3A]">
                <h2 class="text-lg font-semibold text-[#1b1b18] dark:text-[#EDEDEC]">
                    Información Personal
                </h2>
            </div>

            <form action="{{ route('user-profile.update') }}" method="POST" class="p-6">
                @csrf
                @method('PUT')

                <x-user-profile-block::input 
                    label="Nombre"
                    name="name"
                    value="{{ $user->name }}"
                    required
                />

                <x-user-profile-block::input 
                    label="Email"
                    name="email"
                    type="email"
                    value="{{ $user->email }}"
                    required
                />

                <div class="flex gap-4 mt-6">
                    <x-user-profile-block::button>
                        Guardar Cambios
                    </x-user-profile-block::button>
                </div>
            </form>
        </div>

        <!-- Update Password -->
        <div class="bg-white dark:bg-[#161615] border border-[#e3e3e0] dark:border-[#3E3E3A] rounded-xl shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-[#e3e3e0] dark:border-[#3E3E3A]">
                <h2 class="text-lg font-semibold text-[#1b1b18] dark:text-[#EDEDEC]">
                    Cambiar Contraseña
                </h2>
            </div>

            <form action="{{ route('user-profile.password.update') }}" method="POST" class="p-6">
                @csrf
                @method('PUT')

                <x-user-profile-block::input 
                    label="Contraseña Actual"
                    name="current_password"
                    type="password"
                    required
                />

                <x-user-profile-block::input 
                    label="Nueva Contraseña"
                    name="password"
                    type="password"
                    required
                />

                <x-user-profile-block::input 
                    label="Confirmar Nueva Contraseña"
                    name="password_confirmation"
                    type="password"
                    required
                />

                <div class="flex gap-4 mt-6">
                    <x-user-profile-block::button>
                        Actualizar Contraseña
                    </x-user-profile-block::button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
