@props([
    'type' => 'submit',
    'variant' => 'primary',
])

@php
    $variantClasses = [
        'primary' => 'bg-[#FF2D20] text-white hover:bg-[#d6251a]',
        'secondary' => 'bg-[#1b1b18] dark:bg-white text-white dark:text-[#1b1b18] hover:bg-[#3E3E3A] dark:hover:bg-[#f5f5f4]',
    ];
@endphp

<button 
    type="{{ $type }}"
    {{ $attributes->merge(['class' => 'px-6 py-3 rounded-lg font-semibold transition-colors ' . ($variantClasses[$variant] ?? $variantClasses['primary'])]) }}
>
    {{ $slot }}
</button>
