<?php

namespace App\Blocks\UserProfile\Services;

use App\Models\User;
use Illuminate\Support\Facades\Hash;

class UserProfileService
{
    /**
     * Update user profile information.
     */
    public function updateProfile(User $user, array $data): User
    {
        $user->update([
            'name' => $data['name'],
            'email' => $data['email'],
        ]);

        return $user->fresh();
    }

    /**
     * Update user password.
     */
    public function updatePassword(User $user, string $password): User
    {
        $user->update([
            'password' => Hash::make($password),
        ]);

        return $user->fresh();
    }
}
