<?php

namespace App\Blocks\UserProfile\Controllers;

use App\Blocks\UserProfile\Requests\UpdatePasswordRequest;
use App\Blocks\UserProfile\Requests\UpdateProfileRequest;
use App\Blocks\UserProfile\Services\UserProfileService;
use App\Http\Controllers\Controller;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class UserProfileController extends Controller
{
    public function __construct(
        protected UserProfileService $profileService
    ) {}

    /**
     * Show the user profile page.
     */
    public function show(): View
    {
        return view('user-profile-block::profile.show', [
            'user' => auth()->user(),
        ]);
    }

    /**
     * Update the user's profile information.
     */
    public function updateProfile(UpdateProfileRequest $request): RedirectResponse
    {
        $this->profileService->updateProfile(
            $request->user(),
            $request->validated()
        );

        return redirect()->route('user-profile.show')
            ->with('success', 'Perfil actualizado exitosamente.');
    }

    /**
     * Update the user's password.
     */
    public function updatePassword(UpdatePasswordRequest $request): RedirectResponse
    {
        $this->profileService->updatePassword(
            $request->user(),
            $request->validated()['password']
        );

        return redirect()->route('user-profile.show')
            ->with('success', 'Contraseña actualizada exitosamente.');
    }
}
