# User Profile Block (Light) - Laravel 12

Un bloque de gestión de perfil de usuario simple y elegante para Laravel 12, diseñado para permitir a los usuarios autenticados gestionar su información personal y cambiar su contraseña.

## 📋 Descripción

Este **User Profile Block (Light)** proporciona una implementación limpia y reutilizable para la gestión del perfil del usuario autenticado con:

- Vista de perfil del usuario
- Edición de datos básicos (nombre y email)
- Cambio de contraseña
- Validaciones robustas con Form Requests
- Componentes Blade reutilizables
- Diseño moderno con Tailwind CSS
- Arquitectura limpia y fácil de extender

**Importante:** Este es un bloque LIGHT. Está diseñado para ser integrado fácilmente en proyectos Laravel 12. No incluye avatar, roles, preferencias avanzadas, historial de actividad, panel administrativo ni funcionalidades complejas.

## 🎯 Características

- ✅ Vista de perfil del usuario autenticado
- ✅ Edición de nombre y email
- ✅ Cambio de contraseña con validación
- ✅ Validaciones robustas con Form Requests
- ✅ Lógica de negocio en Services
- ✅ Componentes Blade reutilizables (Input, Button)
- ✅ Diseño limpio y profesional con Tailwind CSS
- ✅ Compatible con dark mode
- ✅ Mensajes flash de éxito/error
- ✅ Rutas aisladas del bloque
- ✅ Sin dependencias externas

## 📦 Requisitos

- Laravel 12.x
- PHP 8.3 o superior
- Tailwind CSS configurado en el proyecto
- Tabla `users` existente en la base de datos
- Sistema de autenticación configurado

## 🚀 Instalación

### 1. Copiar archivos

Copia la carpeta `app/Blocks/UserProfile/` a tu proyecto Laravel en la misma ubicación.

### 2. Registrar Service Provider

Añade el Service Provider en `bootstrap/providers.php`:

```php
<?php

return [
    App\Providers\AppServiceProvider::class,
    App\Blocks\UserProfile\UserProfileServiceProvider::class, // ← Añadir esta línea
];
```

### 3. Verificar layout

Asegúrate de que tu layout principal (`resources/views/layouts/app.blade.php`) esté disponible, ya que las vistas del bloque lo extienden.

### 4. Limpiar caché (opcional)

```bash
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

## 💡 Uso

### Rutas disponibles

Una vez instalado, el bloque proporciona las siguientes rutas:

- `GET /profile` - Ver y editar perfil
- `PUT /profile` - Actualizar información del perfil
- `PUT /profile/password` - Actualizar contraseña

### Acceder al perfil

Los usuarios autenticados pueden acceder a su perfil en:

```
/profile
```

### Ejemplo de integración en el menú

Agrega un enlace en tu navbar o menú:

```blade
@auth
    <a href="{{ route('user-profile.show') }}" class="...">
        Mi Perfil
    </a>
@endauth
```

## 🔧 Personalización

### Cambiar las rutas

Edita `app/Blocks/UserProfile/routes.php` para cambiar los prefijos o nombres de rutas.

### Personalizar las vistas

Las vistas están en `app/Blocks/UserProfile/Views/`. Puedes modificarlas directamente según tus necesidades.

### Personalizar componentes

Los componentes están en `app/Blocks/UserProfile/Views/components/`. Puedes modificar los estilos o agregar nuevos componentes.

## 📁 Estructura del Bloque

```
user-profile-laravel12/
├── app/
│   └── Blocks/
│       └── UserProfile/
│           ├── Controllers/
│           │   └── UserProfileController.php
│           ├── Requests/
│           │   ├── UpdateProfileRequest.php
│           │   └── UpdatePasswordRequest.php
│           ├── Services/
│           │   └── UserProfileService.php
│           ├── Views/
│           │   ├── components/
│           │   │   ├── input.blade.php
│           │   │   └── button.blade.php
│           │   └── profile/
│           │       └── show.blade.php
│           ├── routes.php
│           └── UserProfileServiceProvider.php
├── docs/
│   └── INSTALLATION.md
├── README.md
└── LICENSE.txt
```

## 🔧 Notas Técnicas

- El bloque asume que la tabla `users` ya existe
- El bloque asume que la autenticación básica está configurada
- Las validaciones incluyen verificación de email único (excepto para el usuario actual)
- El cambio de contraseña valida la contraseña actual antes de permitir el cambio
- Las contraseñas se hashean automáticamente usando `Hash::make()`

## ⚠️ Limitaciones (Bloque Light)

Este bloque NO incluye:
- Avatar o subida de fotos
- Roles o permisos
- Preferencias avanzadas
- Historial de actividad
- Panel administrativo
- Multi-usuario
- 2FA (Autenticación de dos factores)
- Paquetes externos

## 📝 Validaciones

### Actualizar Perfil

- `name`: Requerido, string, máximo 255 caracteres
- `email`: Requerido, email válido, único en la tabla users (excepto el usuario actual)

### Cambiar Contraseña

- `current_password`: Requerido, debe coincidir con la contraseña actual
- `password`: Requerido, confirmado, cumple con las reglas de Password de Laravel
- `password_confirmation`: Debe coincidir con `password`

## 🎯 Compatibilidad

- Laravel 12.x
- PHP 8.3+
- Tailwind CSS 3.x o superior

## 📄 Licencia

Este bloque es gratuito y está disponible bajo la licencia MIT. Ver `LICENSE.txt` para más detalles.

---

**User Profile Block (Light) v1.0.0** - Laravel 12
