<?php

namespace App\Blocks\Validation\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class StrongPassword implements ValidationRule
{
    /**
     * Run the validation rule.
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // At least 8 characters
        if (strlen($value) < 8) {
            $fail('El campo :attribute debe tener al menos 8 caracteres.');
            return;
        }

        // At least one uppercase letter
        if (!preg_match('/[A-Z]/', $value)) {
            $fail('El campo :attribute debe contener al menos una letra mayúscula.');
            return;
        }

        // At least one lowercase letter
        if (!preg_match('/[a-z]/', $value)) {
            $fail('El campo :attribute debe contener al menos una letra minúscula.');
            return;
        }

        // At least one number
        if (!preg_match('/[0-9]/', $value)) {
            $fail('El campo :attribute debe contener al menos un número.');
            return;
        }

        // At least one special character
        if (!preg_match('/[^A-Za-z0-9]/', $value)) {
            $fail('El campo :attribute debe contener al menos un carácter especial.');
            return;
        }
    }
}
