<?php

namespace App\Blocks\Validation\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SearchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'search' => [
                'nullable',
                'string',
                'max:255',
                'min:2',
            ],
            'query' => [
                'nullable',
                'string',
                'max:255',
                'min:2',
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'search.string' => 'El término de búsqueda debe ser texto.',
            'search.max' => 'El término de búsqueda no puede tener más de :max caracteres.',
            'search.min' => 'El término de búsqueda debe tener al menos :min caracteres.',
            'query.string' => 'La consulta de búsqueda debe ser texto.',
            'query.max' => 'La consulta de búsqueda no puede tener más de :max caracteres.',
            'query.min' => 'La consulta de búsqueda debe tener al menos :min caracteres.',
        ];
    }

    /**
     * Get the search term (supports both 'search' and 'query' parameters).
     */
    public function getSearchTerm(): ?string
    {
        $validated = $this->validated();

        return $validated['search'] ?? $validated['query'] ?? null;
    }
}
