<?php

namespace App\Blocks\Validation\Requests;

use Illuminate\Foundation\Http\FormRequest;

class PaginationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     */
    public function rules(): array
    {
        return [
            'page' => [
                'nullable',
                'integer',
                'min:1',
            ],
            'per_page' => [
                'nullable',
                'integer',
                'min:1',
                'max:100',
            ],
        ];
    }

    /**
     * Get custom messages for validator errors.
     */
    public function messages(): array
    {
        return [
            'page.integer' => 'El número de página debe ser un número entero.',
            'page.min' => 'El número de página debe ser al menos :min.',
            'per_page.integer' => 'El número de elementos por página debe ser un número entero.',
            'per_page.min' => 'El número de elementos por página debe ser al menos :min.',
            'per_page.max' => 'El número de elementos por página no puede ser mayor a :max.',
        ];
    }

    /**
     * Get validated pagination parameters with defaults.
     */
    public function getPaginationParams(): array
    {
        $validated = $this->validated();

        return [
            'page' => $validated['page'] ?? 1,
            'per_page' => $validated['per_page'] ?? 15,
        ];
    }
}
