<?php

namespace App\Blocks\QueryFilters\Filters;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;

abstract class QueryFilter
{
    /**
     * The request instance.
     */
    protected Request $request;

    /**
     * The query builder instance.
     */
    protected Builder $builder;

    /**
     * Create a new QueryFilter instance.
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    /**
     * Apply the filters to the builder.
     */
    public function apply(Builder $builder): Builder
    {
        $this->builder = $builder;

        foreach ($this->request->all() as $name => $value) {
            if (method_exists($this, $name)) {
                if ($value !== null && $value !== '') {
                    $this->$name($value);
                }
            }
        }

        return $this->builder;
    }
}
