<?php

namespace App\Blocks\QueryFilters\Filters;

use Illuminate\Database\Eloquent\Builder;

/**
 * Example Filters class demonstrating common filter patterns.
 * 
 * Copy this class and customize it for your specific model needs.
 */
class ExampleFilters extends QueryFilter
{
    /**
     * Filter by search term (searches in name and email fields).
     */
    public function search(string $value): void
    {
        $this->builder->where(function ($query) use ($value) {
            $query->where('name', 'like', "%{$value}%")
                  ->orWhere('email', 'like', "%{$value}%");
        });
    }

    /**
     * Filter by status.
     */
    public function status(string $value): void
    {
        $this->builder->where('status', $value);
    }

    /**
     * Order by column and direction.
     * 
     * Usage: ?order_by=name&order_direction=asc
     */
    public function order_by(string $column): void
    {
        $direction = $this->request->get('order_direction', 'asc');
        
        $allowedDirections = ['asc', 'desc'];
        if (!in_array(strtolower($direction), $allowedDirections)) {
            $direction = 'asc';
        }

        $this->builder->orderBy($column, $direction);
    }

    /**
     * Filter by date range (created_at).
     * 
     * Usage: ?date_from=2024-01-01&date_to=2024-12-31
     */
    public function date_from(string $value): void
    {
        $this->builder->whereDate('created_at', '>=', $value);
    }

    /**
     * Filter by date range (created_at).
     */
    public function date_to(string $value): void
    {
        $this->builder->whereDate('created_at', '<=', $value);
    }

    /**
     * Filter by active status (boolean).
     */
    public function active(string $value): void
    {
        $active = filter_var($value, FILTER_VALIDATE_BOOLEAN);
        $this->builder->where('is_active', $active);
    }
}
