<?php

namespace App\Blocks\Maintenance;

use Illuminate\Support\ServiceProvider;

class MaintenanceServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->mergeConfigFrom(
            base_path('config/maintenance.php'),
            'maintenance'
        );
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \App\Blocks\Maintenance\Commands\CleanSoftDeletedCommand::class,
                \App\Blocks\Maintenance\Commands\CleanOrphanedCommand::class,
                \App\Blocks\Maintenance\Commands\CleanOldRecordsCommand::class,
            ]);
        }

        $this->publishes([
            base_path('config/maintenance.php') => config_path('maintenance.php'),
        ], 'maintenance-config');
    }
}
