# Model Cleanup & Maintenance Block (Light) - Laravel 12

Un bloque de herramientas para mantenimiento y limpieza de datos en proyectos Laravel 12, diseñado para proporcionar comandos Artisan seguros y reutilizables para el mantenimiento de bases de datos.

## 📋 Descripción

Este **Model Cleanup & Maintenance Block (Light)** proporciona herramientas simples y reutilizables para el mantenimiento y limpieza de datos en proyectos Laravel usando comandos Artisan:

- Limpiar registros soft-deleted antiguos
- Eliminar registros huérfanos (sin relaciones válidas)
- Limpiar tablas de logs o datos temporales

**Importante:** Este es un bloque LIGHT. NO incluye programación automática (cron), interfaces gráficas ni ejecución automática. Los comandos deben ejecutarse manualmente o configurarse en tu propio sistema de tareas programadas.

## 🎯 Características

- ✅ Comando para limpiar soft-deleted records
- ✅ Comando para eliminar registros huérfanos
- ✅ Comando para limpiar registros antiguos por fecha
- ✅ Servicio `CleanupService` reutilizable
- ✅ Configuración mediante archivo config
- ✅ Confirmaciones de seguridad antes de eliminar
- ✅ Mensajes claros en consola
- ✅ Código seguro y bien estructurado
- ✅ Sin dependencias externas

## 📦 Requisitos

- Laravel 12.x
- PHP 8.3 o superior

## 🚀 Instalación

### 1. Copiar archivos

Copia la carpeta `app/Blocks/Maintenance/` a tu proyecto Laravel en la misma ubicación.

### 2. Copiar archivo de configuración

Copia el archivo `config/maintenance.php` a tu proyecto en la misma ubicación.

### 3. Registrar Service Provider

Añade el Service Provider en `bootstrap/providers.php`:

```php
<?php

return [
    App\Providers\AppServiceProvider::class,
    App\Blocks\Maintenance\MaintenanceServiceProvider::class, // ← Añadir esta línea
];
```

### 4. Limpiar caché (opcional)

```bash
php artisan config:clear
```

## 💡 Uso

### Limpiar soft-deleted records

Elimina permanentemente registros soft-deleted más antiguos que X días:

```bash
php artisan maintenance:clean-soft-deleted "App\Models\User" --days=30
```

Con confirmación forzada (sin preguntar):

```bash
php artisan maintenance:clean-soft-deleted "App\Models\User" --days=30 --force
```

### Limpiar registros huérfanos

Elimina registros que no tienen una relación válida con su tabla padre:

```bash
php artisan maintenance:clean-orphaned "App\Models\Comment" user
```

Con tabla padre especificada:

```bash
php artisan maintenance:clean-orphaned "App\Models\Comment" user --parent-table=users
```

Con confirmación forzada:

```bash
php artisan maintenance:clean-orphaned "App\Models\Comment" user --force
```

### Limpiar registros antiguos

Elimina registros de una tabla más antiguos que X días:

```bash
php artisan maintenance:clean-old-records logs created_at --days=90
```

Con confirmación forzada:

```bash
php artisan maintenance:clean-old-records logs created_at --days=90 --force
```

## 📁 Estructura del Bloque

```
model-cleanup-laravel12/
├── app/
│   └── Blocks/
│       └── Maintenance/
│           ├── Commands/
│           │   ├── CleanSoftDeletedCommand.php
│           │   ├── CleanOrphanedCommand.php
│           │   └── CleanOldRecordsCommand.php
│           ├── Services/
│           │   └── CleanupService.php
│           └── MaintenanceServiceProvider.php
├── config/
│   └── maintenance.php
├── docs/
│   └── INSTALLATION.md
├── README.md
└── LICENSE.txt
```

## 🔧 Comandos Disponibles

### maintenance:clean-soft-deleted

Limpia registros soft-deleted más antiguos que el número de días especificado.

**Parámetros:**
- `model` (requerido) - La clase del modelo (ej: `App\Models\User`)
- `--days` (opcional) - Número de días a mantener (default: 30)
- `--force` (opcional) - Ejecutar sin confirmación

**Ejemplo:**
```bash
php artisan maintenance:clean-soft-deleted "App\Models\Post" --days=60
```

### maintenance:clean-orphaned

Elimina registros huérfanos (sin relación válida con la tabla padre).

**Parámetros:**
- `model` (requerido) - La clase del modelo (ej: `App\Models\Comment`)
- `relation` (requerido) - El nombre de la relación (ej: `user`)
- `--parent-table` (opcional) - El nombre de la tabla padre (se detecta automáticamente)
- `--force` (opcional) - Ejecutar sin confirmación

**Ejemplo:**
```bash
php artisan maintenance:clean-orphaned "App\Models\Comment" user
```

### maintenance:clean-old-records

Limpia registros de una tabla más antiguos que el número de días especificado.

**Parámetros:**
- `table` (requerido) - El nombre de la tabla
- `date-column` (requerido) - El nombre de la columna de fecha (ej: `created_at`)
- `--days` (opcional) - Número de días a mantener (default: 30)
- `--force` (opcional) - Ejecutar sin confirmación

**Ejemplo:**
```bash
php artisan maintenance:clean-old-records logs created_at --days=90
```

## 📝 Ejemplos de Uso

### Ejemplo 1: Limpiar usuarios soft-deleted

```bash
php artisan maintenance:clean-soft-deleted "App\Models\User" --days=30
```

Esto eliminará permanentemente todos los usuarios que fueron eliminados (soft-deleted) hace más de 30 días.

### Ejemplo 2: Limpiar comentarios huérfanos

Si tienes comentarios que pertenecen a usuarios que ya no existen:

```bash
php artisan maintenance:clean-orphaned "App\Models\Comment" user
```

Esto eliminará todos los comentarios cuyo `user_id` no existe en la tabla `users`.

### Ejemplo 3: Limpiar logs antiguos

```bash
php artisan maintenance:clean-old-records logs created_at --days=90
```

Esto eliminará todos los registros de la tabla `logs` más antiguos que 90 días.

### Ejemplo 4: Programar limpieza (usar en tu scheduler)

En `app/Console/Kernel.php`:

```php
protected function schedule(Schedule $schedule): void
{
    // Limpiar soft-deleted cada semana
    $schedule->command('maintenance:clean-soft-deleted "App\Models\User" --days=30 --force')
             ->weekly();
    
    // Limpiar logs antiguos cada mes
    $schedule->command('maintenance:clean-old-records logs created_at --days=90 --force')
             ->monthly();
}
```

## ⚠️ Notas Importantes

- **Este bloque NO ejecuta acciones automáticamente** - Los comandos deben ejecutarse manualmente o configurarse en tu scheduler
- **Confirmaciones de seguridad** - Por defecto, todos los comandos piden confirmación antes de eliminar datos
- **Uso de --force** - Solo usa `--force` cuando estés seguro o en scripts automatizados
- **Backups recomendados** - Siempre haz backups antes de ejecutar operaciones de limpieza en producción
- **Probado primero** - Prueba los comandos en un entorno de desarrollo antes de usarlos en producción

## 🔧 Configuración

El archivo `config/maintenance.php` contiene valores por defecto y documentación:

```php
return [
    'defaults' => [
        'soft_deleted_days' => 30,
        'old_records_days' => 30,
    ],
];
```

## 🎯 Compatibilidad

- Laravel 12.x
- PHP 8.3+

## 📄 Licencia

Este bloque es gratuito y está disponible bajo la licencia MIT. Ver `LICENSE.txt` para más detalles.

---

**Model Cleanup & Maintenance Block (Light) v1.0.0** - Laravel 12
