@php
    use App\Blocks\Notifications\Models\Notification;
    use App\Blocks\Notifications\Services\NotificationService;
    
    $notifications = NotificationService::forUser(auth()->user(), 10);
    $unreadCount = NotificationService::unreadCount(auth()->user());
    $notificationsId = 'notifications-' . uniqid();
@endphp

<div class="relative" id="notifications-container-{{ $notificationsId }}">
    <!-- Notifications Button -->
    <button 
        type="button"
        id="notifications-button-{{ $notificationsId }}"
        class="relative p-2 text-[#1b1b18] dark:text-[#EDEDEC] hover:text-[#FF2D20] transition-colors"
        aria-label="Notificaciones"
        aria-expanded="false"
    >
        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"/>
        </svg>
        @if($unreadCount > 0)
            <span class="absolute top-0 right-0 block h-2 w-2 rounded-full bg-[#FF2D20] ring-2 ring-white dark:ring-[#0a0a0a]"></span>
            <span class="absolute -top-1 -right-1 flex h-5 w-5 items-center justify-center rounded-full bg-[#FF2D20] text-xs font-bold text-white">
                {{ $unreadCount > 9 ? '9+' : $unreadCount }}
            </span>
        @endif
    </button>

    <!-- Notifications Dropdown -->
    <div 
        id="notifications-dropdown-{{ $notificationsId }}"
        class="hidden absolute right-0 mt-2 w-80 md:w-96 bg-white dark:bg-[#161615] border border-[#e3e3e0] dark:border-[#3E3E3A] rounded-lg shadow-lg z-50 max-h-96 overflow-hidden"
    >
        <!-- Header -->
        <div class="px-4 py-3 border-b border-[#e3e3e0] dark:border-[#3E3E3A] flex items-center justify-between">
            <h3 class="text-sm font-semibold text-[#1b1b18] dark:text-[#EDEDEC]">
                Notificaciones
                @if($unreadCount > 0)
                    <span class="ml-2 text-xs font-normal text-[#706f6c] dark:text-[#A1A09A]">
                        ({{ $unreadCount }} sin leer)
                    </span>
                @endif
            </h3>
            @if($unreadCount > 0)
                <form action="{{ route('notifications.markAllAsRead') }}" method="POST" class="inline">
                    @csrf
                    <button type="submit" class="text-xs text-[#FF2D20] hover:underline">
                        Marcar todas como leídas
                    </button>
                </form>
            @endif
        </div>

        <!-- Notifications List -->
        <div class="overflow-y-auto max-h-80">
            @forelse($notifications as $notification)
                <div class="px-4 py-3 border-b border-[#e3e3e0] dark:border-[#3E3E3A] hover:bg-[#f5f5f4] dark:hover:bg-[#1b1b18] transition-colors {{ $notification->isRead() ? 'opacity-75' : 'bg-blue-50/50 dark:bg-blue-900/10' }}">
                    <div class="flex items-start justify-between gap-3">
                        <div class="flex-1 min-w-0">
                            <div class="flex items-start gap-2">
                                @if(!$notification->isRead())
                                    <span class="mt-1.5 h-2 w-2 rounded-full bg-[#FF2D20] flex-shrink-0"></span>
                                @endif
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-[#1b1b18] dark:text-[#EDEDEC]">
                                        {{ $notification->title }}
                                    </p>
                                    <p class="text-xs text-[#706f6c] dark:text-[#A1A09A] mt-1">
                                        {{ $notification->body }}
                                    </p>
                                    <p class="text-xs text-[#706f6c] dark:text-[#A1A09A] mt-1">
                                        {{ $notification->created_at->diffForHumans() }}
                                    </p>
                                </div>
                            </div>
                        </div>
                        @if(!$notification->isRead())
                            <form action="{{ route('notifications.markAsRead', $notification) }}" method="POST" class="flex-shrink-0">
                                @csrf
                                <button 
                                    type="submit"
                                    class="text-xs text-[#FF2D20] hover:underline whitespace-nowrap"
                                    title="Marcar como leída"
                                >
                                    Marcar como leída
                                </button>
                            </form>
                        @endif
                    </div>
                </div>
            @empty
                <div class="px-4 py-8 text-center">
                    <p class="text-sm text-[#706f6c] dark:text-[#A1A09A]">
                        No tienes notificaciones
                    </p>
                </div>
            @endforelse
        </div>
    </div>

    <script>
        (function() {
            const button = document.getElementById('notifications-button-{{ $notificationsId }}');
            const dropdown = document.getElementById('notifications-dropdown-{{ $notificationsId }}');
            
            if (button && dropdown) {
                // Toggle dropdown
                button.addEventListener('click', function(e) {
                    e.stopPropagation();
                    const isHidden = dropdown.classList.contains('hidden');
                    
                    if (isHidden) {
                        dropdown.classList.remove('hidden');
                        button.setAttribute('aria-expanded', 'true');
                    } else {
                        dropdown.classList.add('hidden');
                        button.setAttribute('aria-expanded', 'false');
                    }
                });
                
                // Close dropdown when clicking outside
                document.addEventListener('click', function(e) {
                    if (!button.contains(e.target) && !dropdown.contains(e.target)) {
                        dropdown.classList.add('hidden');
                        button.setAttribute('aria-expanded', 'false');
                    }
                });
            }
        })();
    </script>
</div>
