<?php

use App\Blocks\Notifications\Controllers\NotificationController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Notifications Block Routes
|--------------------------------------------------------------------------
|
| These routes are loaded by the NotificationsServiceProvider and are isolated
| to the notifications block namespace.
|
*/

Route::middleware(['web', 'auth'])->group(function () {
    Route::post('/notifications/{notification}/read', [NotificationController::class, 'markAsRead'])
        ->name('notifications.markAsRead');
    
    Route::post('/notifications/mark-all-read', [NotificationController::class, 'markAllAsRead'])
        ->name('notifications.markAllAsRead');
});
