<?php

namespace App\Blocks\Notifications\Services;

use App\Blocks\Notifications\Models\Notification;
use App\Models\User;

class NotificationService
{
    /**
     * Send a notification to a user.
     *
     * @param User $user
     * @param string $title
     * @param string $body
     * @return Notification
     */
    public static function send(User $user, string $title, string $body): Notification
    {
        return Notification::create([
            'user_id' => $user->id,
            'title' => $title,
            'body' => $body,
        ]);
    }

    /**
     * Get unread notifications count for a user.
     *
     * @param User $user
     * @return int
     */
    public static function unreadCount(User $user): int
    {
        return Notification::where('user_id', $user->id)
            ->unread()
            ->count();
    }

    /**
     * Get all notifications for a user.
     *
     * @param User $user
     * @param int $limit
     * @return \Illuminate\Database\Eloquent\Collection
     */
    public static function forUser(User $user, int $limit = 10)
    {
        return Notification::where('user_id', $user->id)
            ->orderBy('created_at', 'desc')
            ->limit($limit)
            ->get();
    }
}
