<?php

namespace App\Blocks\Notifications\Controllers;

use App\Blocks\Notifications\Models\Notification;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class NotificationController extends Controller
{
    /**
     * Mark a notification as read.
     */
    public function markAsRead(Notification $notification)
    {
        if ($notification->user_id !== Auth::id()) {
            abort(403, 'No autorizado.');
        }

        $notification->markAsRead();

        return back()->with('success', 'Notificación marcada como leída.');
    }

    /**
     * Mark all notifications as read for the authenticated user.
     */
    public function markAllAsRead()
    {
        Notification::where('user_id', Auth::id())
            ->unread()
            ->update(['read_at' => now()]);

        return back()->with('success', 'Todas las notificaciones han sido marcadas como leídas.');
    }
}
