# Guía de Instalación - Flash Messages Block

Esta guía te ayudará a integrar el bloque Flash Messages en tu proyecto Laravel 12.

## 📋 Requisitos Previos

- Laravel 12.x instalado
- PHP 8.3 o superior
- Tailwind CSS configurado en tu proyecto

## 🚀 Pasos de Instalación

### Paso 1: Extraer el contenido

**Importante:** Descomprime el archivo ZIP en la **raíz de tu proyecto Laravel** (donde están las carpetas `app/`, `config/`, `routes/`, `bootstrap/`, `resources/`, etc.).

Al descomprimir el ZIP, la estructura de archivos quedará así:

```
tu-proyecto-laravel/
├── app/
├── config/
├── resources/
│   └── views/
│       └── components/
│           └── flash.blade.php    ← El componente queda aquí
├── README.md
├── LICENSE.txt
└── docs/
    └── INSTALLATION.md
```

**Nota:** Asegúrate de descomprimir el ZIP en la raíz del proyecto, no dentro de una subcarpeta. El componente debe quedar en `resources/views/components/flash.blade.php`.

### Paso 2: Verificar la ubicación del componente

Verifica que el archivo `flash.blade.php` esté en la ubicación correcta:

```
resources/views/components/flash.blade.php
```

Si la carpeta `components` no existe, créala:

```bash
mkdir -p resources/views/components
```

### Paso 3: Integrar en tu layout

Abre tu layout principal (generalmente `resources/views/layouts/app.blade.php` o `resources/views/layouts/master.blade.php`) y agrega el componente:

```blade
<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title', 'App')</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>
<body>
    {{-- Agregar el componente flash aquí --}}
    <x-flash />
    
    @yield('content')
</body>
</html>
```

### Paso 4: Probar la instalación

Para verificar que todo funciona correctamente, crea una ruta de prueba:

```php
// En routes/web.php
Route::get('/test-flash', function () {
    return redirect()->route('home')
        ->with('success', '¡El componente Flash Messages funciona correctamente!');
});
```

O prueba desde un controlador existente:

```php
public function test()
{
    return redirect()->back()
        ->with('success', 'Mensaje de prueba');
}
```

## ✅ Verificación

Si todo está correcto, deberías ver:

1. ✅ El componente se renderiza cuando hay mensajes flash
2. ✅ Los mensajes aparecen en la esquina superior derecha (por defecto)
3. ✅ Los colores son correctos para cada tipo (success = verde, error = rojo, etc.)
4. ✅ Los iconos se muestran correctamente
5. ✅ El modo oscuro funciona si está habilitado

## 🔧 Solución de Problemas

### El componente no se muestra

1. **Verifica la ubicación del archivo:**
   ```bash
   ls -la resources/views/components/flash.blade.php
   ```
   
2. **Limpia el cache de vistas:**
   ```bash
   php artisan view:clear
   ```

3. **Verifica que hay mensajes en la sesión:**
   ```php
   // En tu controlador
   dd(session()->all()); // Verifica que existan 'success', 'error', etc.
   ```

### Los estilos no se aplican

1. **Verifica que Tailwind CSS esté configurado correctamente**
2. **Asegúrate de compilar los assets:**
   ```bash
   npm run build
   # o
   npm run dev
   ```

### El componente muestra errores

1. **Verifica que estás usando Laravel 12.x:**
   ```bash
   php artisan --version
   ```

2. **Verifica que PHP es 8.3 o superior:**
   ```bash
   php -v
   ```

3. **Revisa los logs de Laravel:**
   ```bash
   tail -f storage/logs/laravel.log
   ```

## 📝 Uso Básico

### Desde un controlador

```php
use Illuminate\Http\Request;
use App\Models\Product;

class ProductController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'description' => 'required|string',
        ]);

        Product::create($validated);

        return redirect()->route('products.index')
            ->with('success', 'Producto creado exitosamente.');
    }

    public function destroy(Product $product)
    {
        $product->delete();

        return redirect()->route('products.index')
            ->with('success', 'Producto eliminado correctamente.');
    }
}
```

### Múltiples mensajes

Puedes enviar múltiples mensajes en una sola redirección:

```php
return redirect()->route('dashboard')
    ->with('success', 'Operación completada.')
    ->with('info', 'Revisa la configuración si es necesario.');
```

## 🎨 Personalización (Opcional)

Si deseas personalizar el componente, edita directamente `resources/views/components/flash.blade.php`:

- **Cambiar posición:** Modifica las clases `top-4 right-4`
- **Cambiar colores:** Edita el array `$colors`
- **Cambiar iconos:** Modifica el array `$icons`
- **Cambiar tamaño:** Ajusta `max-w-md`

## 📚 Documentación Adicional

Para más información, consulta:
- `README.md` - Documentación completa del bloque
- `LICENSE.txt` - Términos de licencia

## 🎯 Próximos Pasos

Una vez instalado el componente:

1. Integra el componente en tu layout principal
2. Comienza a usar mensajes flash en tus controladores
3. Personaliza los colores y estilos según tus necesidades
4. ¡Disfruta de mensajes flash elegantes en tu aplicación!

---

**¿Necesitas ayuda?** Consulta la documentación de Laravel sobre [mensajes flash](https://laravel.com/docs/session#flash-data).
