# Flash Messages Block - Laravel 12

Un bloque de mensajes flash reutilizable y elegante para Laravel 12, diseñado para mostrar notificaciones de forma simple y profesional.

## 📋 Descripción

Este **Flash Messages Block** proporciona un componente Blade para mostrar mensajes flash de tipo `success`, `error`, `warning` e `info` con:

- Diseño elegante y moderno con Tailwind CSS
- Compatible con modo oscuro (dark mode)
- Iconos SVG integrados
- Colores diferenciados por tipo de mensaje
- Sin dependencias de JavaScript externo
- Componente Blade anónimo simple

**Importante:** Este es un bloque, no una aplicación completa. Está diseñado para ser integrado fácilmente en proyectos Laravel 12.

## 🎯 Características

- ✅ Componente Blade simple (`<x-flash />`)
- ✅ Soporte para 4 tipos de mensajes: `success`, `error`, `warning`, `info`
- ✅ Diseño limpio y profesional con Tailwind CSS
- ✅ Compatible con dark mode
- ✅ Iconos SVG integrados
- ✅ Colores diferenciados por tipo
- ✅ Sin JavaScript externo requerido
- ✅ Sin dependencias adicionales

## 📦 Requisitos

- Laravel 12.x
- PHP 8.3 o superior
- Tailwind CSS configurado en el proyecto

## 🚀 Instalación

### 1. Copiar el componente

Copia el archivo `resources/views/components/flash.blade.php` a tu proyecto Laravel en la misma ubicación:

```
tu-proyecto-laravel/
└── resources/
    └── views/
        └── components/
            └── flash.blade.php    ← Copiar aquí
```

### 2. Listo para usar

¡Eso es todo! El componente está listo para usar.

## 💡 Uso

### En tus vistas Blade

Incluye el componente en tu layout principal (por ejemplo, en `resources/views/layouts/app.blade.php`):

```blade
<body>
    <x-flash />
    
    @yield('content')
</body>
```

### En tus controladores

Envía mensajes flash desde tus controladores:

```php
// Mensaje de éxito
return redirect()->route('dashboard')
    ->with('success', 'Operación completada exitosamente.');

// Mensaje de error
return back()->with('error', 'Ocurrió un error al procesar la solicitud.');

// Mensaje de advertencia
return redirect()->route('settings')
    ->with('warning', 'Por favor, revisa la configuración.');

// Mensaje informativo
return back()->with('info', 'Esta acción requiere confirmación.');
```

### Ejemplo completo

```php
// En un controlador
public function store(Request $request)
{
    // Validar y guardar
    $product = Product::create($request->validated());
    
    return redirect()->route('products.index')
        ->with('success', 'Producto creado exitosamente.');
}
```

```blade
{{-- En tu vista --}}
<x-flash />
```

## 🎨 Personalización

### Cambiar la posición

Por defecto, los mensajes aparecen en la esquina superior derecha (`top-4 right-4`). Puedes modificar esto editando el componente:

```blade
<div class="fixed top-4 right-4 z-50 max-w-md w-full space-y-3">
    {{-- Cambiar a: top-4 left-4, bottom-4 right-4, etc. --}}
</div>
```

### Cambiar los colores

Los colores están definidos en el array `$colors` dentro del componente. Puedes modificar las clases de Tailwind según tus necesidades:

```php
$colors = [
    'success' => [
        'bg' => 'bg-green-50 dark:bg-green-900/20',
        'border' => 'border-green-200 dark:border-green-800',
        'text' => 'text-green-800 dark:text-green-200',
        'icon' => 'text-green-400 dark:text-green-500',
    ],
    // ... otros tipos
];
```

### Cambiar el tamaño máximo

Modifica la clase `max-w-md` para cambiar el ancho máximo de los mensajes:

```blade
<div class="fixed top-4 right-4 z-50 max-w-lg w-full space-y-3">
    {{-- max-w-sm, max-w-md, max-w-lg, max-w-xl, etc. --}}
</div>
```

## 📁 Estructura del Bloque

```
flash-messages-laravel12/
├── resources/
│   └── views/
│       └── components/
│           └── flash.blade.php    # Componente principal
├── README.md                       # Esta documentación
├── LICENSE.txt                     # Licencia
└── docs/
    └── INSTALLATION.md             # Guía de instalación detallada
```

## 🔧 Notas Técnicas

- Los mensajes flash de Laravel se muestran una vez y desaparecen automáticamente en la siguiente petición
- El componente verifica si existen mensajes antes de renderizar
- Compatible con la sesión de Laravel (`session()->flash()`)
- No requiere JavaScript para funcionar

## 📝 Tipos de Mensajes

| Tipo | Uso recomendado |
|------|----------------|
| `success` | Operaciones exitosas, confirmaciones |
| `error` | Errores, validaciones fallidas |
| `warning` | Advertencias, confirmaciones requeridas |
| `info` | Información general, tips |

## ⚠️ Importante

- Este bloque no sobrescribe ningún archivo existente
- Puedes tener múltiples componentes flash si lo necesitas
- El componente solo se renderiza si hay mensajes en la sesión
- Compatible con proyectos Laravel 12 nuevos o existentes

## 🎯 Compatibilidad

- Laravel 12.x
- PHP 8.3+
- Tailwind CSS 3.x o superior

## 📄 Licencia

Este bloque es gratuito y está disponible bajo la licencia MIT. Ver `LICENSE.txt` para más detalles.

---

**Flash Messages Block v1.0.0** - Laravel 12
