<?php

use App\Blocks\Auth\Controllers\AuthController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Authentication Block Routes
|--------------------------------------------------------------------------
|
| These routes are loaded by the AuthServiceProvider and are isolated
| to the authentication block namespace.
|
*/

Route::middleware('web')->group(function () {
    // Login routes
    Route::get('/login', [AuthController::class, 'showLoginForm'])->name('auth.login');
    Route::post('/login', [AuthController::class, 'login'])->name('auth.login.submit');
    
    // Register routes
    Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('auth.register');
    Route::post('/register', [AuthController::class, 'register'])->name('auth.register.submit');
    
    // Logout route
    Route::post('/logout', [AuthController::class, 'logout'])->name('auth.logout');
    
    // Dashboard route (protected)
    Route::middleware('auth')->group(function () {
        Route::get('/dashboard', [AuthController::class, 'dashboard'])->name('auth.dashboard');
    });
});
