<x-auth-block::layout title="Registro">
    <div class="flex flex-1 items-center justify-center px-4 py-12 sm:px-6 lg:px-8">
        <div class="w-full max-w-md space-y-8">
            <!-- Header -->
            <div class="text-center">
                <h1 class="text-3xl font-bold tracking-tight text-gray-900">
                    Crear Cuenta
                </h1>
                <p class="mt-2 text-sm text-gray-600">
                    Completa el formulario para registrarte
                </p>
            </div>

            <!-- Register Form -->
            <div class="rounded-lg bg-white px-6 py-8 shadow-sm ring-1 ring-gray-200">
                <!-- General Errors -->
                @if($errors->any() && !$errors->has('name') && !$errors->has('email') && !$errors->has('password') && !$errors->has('password_confirmation'))
                    <div class="mb-6">
                        <x-auth-block::alert type="error">
                            <ul class="list-disc list-inside space-y-1">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-auth-block::alert>
                    </div>
                @endif

                <form method="POST" action="{{ route('auth.register.submit') }}" class="space-y-6">
                    @csrf

                    <!-- Name Input -->
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Nombre Completo
                        </label>
                        <x-auth-block::input
                            name="name"
                            type="text"
                            placeholder="Juan Pérez"
                            autocomplete="name"
                            :error="$errors->first('name')"
                        />
                    </div>

                    <!-- Email Input -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Correo Electrónico
                        </label>
                        <x-auth-block::input
                            name="email"
                            type="email"
                            placeholder="tu@email.com"
                            autocomplete="email"
                            :error="$errors->first('email')"
                        />
                    </div>

                    <!-- Password Input -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Contraseña
                        </label>
                        <x-auth-block::input
                            name="password"
                            type="password"
                            placeholder="••••••••"
                            autocomplete="new-password"
                            :error="$errors->first('password')"
                        />
                    </div>

                    <!-- Password Confirmation Input -->
                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Confirmar Contraseña
                        </label>
                        <x-auth-block::input
                            name="password_confirmation"
                            type="password"
                            placeholder="••••••••"
                            autocomplete="new-password"
                            :error="$errors->first('password_confirmation')"
                        />
                    </div>

                    <!-- Submit Button -->
                    <div>
                        <x-auth-block::button type="submit" variant="primary" full-width>
                            Registrarse
                        </x-auth-block::button>
                    </div>
                </form>
            </div>

            <!-- Login Link -->
            <div class="text-center">
                <p class="text-sm text-gray-600">
                    ¿Ya tienes una cuenta?
                    <a href="{{ route('auth.login') }}" class="font-medium text-gray-900 hover:text-gray-700">
                        Inicia sesión
                    </a>
                </p>
            </div>

            <!-- Footer -->
            <p class="text-center text-xs text-gray-500">
                Authentication Block - Laravel 12
            </p>
        </div>
    </div>
</x-auth-block::layout>
