<x-auth-block::layout title="Iniciar Sesión">
    <div class="flex flex-1 items-center justify-center px-4 py-12 sm:px-6 lg:px-8">
        <div class="w-full max-w-md space-y-8">
            <!-- Header -->
            <div class="text-center">
                <h1 class="text-3xl font-bold tracking-tight text-gray-900">
                    Iniciar Sesión
                </h1>
                <p class="mt-2 text-sm text-gray-600">
                    Ingresa tus credenciales para acceder
                </p>
            </div>

            <!-- Login Form -->
            <div class="rounded-lg bg-white px-6 py-8 shadow-sm ring-1 ring-gray-200">
                <!-- General Errors -->
                @if($errors->any() && !$errors->has('email') && !$errors->has('password'))
                    <div class="mb-6">
                        <x-auth-block::alert type="error">
                            <ul class="list-disc list-inside space-y-1">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-auth-block::alert>
                    </div>
                @endif

                <form method="POST" action="{{ route('auth.login.submit') }}" class="space-y-6">
                    @csrf

                    <!-- Email Input -->
                    <div>
                        <label for="email" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Correo Electrónico
                        </label>
                        <x-auth-block::input
                            name="email"
                            type="email"
                            placeholder="tu@email.com"
                            autocomplete="email"
                            :error="$errors->first('email')"
                        />
                    </div>

                    <!-- Password Input -->
                    <div>
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1.5">
                            Contraseña
                        </label>
                        <x-auth-block::input
                            name="password"
                            type="password"
                            placeholder="••••••••"
                            autocomplete="current-password"
                            :error="$errors->first('password')"
                        />
                    </div>

                    <!-- Remember Me -->
                    <div class="flex items-center">
                        <input
                            id="remember"
                            name="remember"
                            type="checkbox"
                            class="h-4 w-4 rounded border-gray-300 text-gray-600 focus:ring-gray-500"
                        >
                        <label for="remember" class="ml-2 block text-sm text-gray-700">
                            Recordarme
                        </label>
                    </div>

                    <!-- Submit Button -->
                    <div>
                        <x-auth-block::button type="submit" variant="primary" full-width>
                            Iniciar Sesión
                        </x-auth-block::button>
                    </div>
                </form>
            </div>

            <!-- Register Link -->
            <div class="text-center">
                <p class="text-sm text-gray-600">
                    ¿No tienes una cuenta?
                    <a href="{{ route('auth.register') }}" class="font-medium text-gray-900 hover:text-gray-700">
                        Regístrate
                    </a>
                </p>
            </div>

            <!-- Footer -->
            <p class="text-center text-xs text-gray-500">
                Authentication Block - Laravel 12
            </p>
        </div>
    </div>
</x-auth-block::layout>
