<x-auth-block::layout title="Dashboard">
    <div class="min-h-screen bg-gray-50">
        <!-- Navigation -->
        <nav class="bg-white border-b border-gray-200">
            <div class="mx-auto max-w-7xl px-4 sm:px-6 lg:px-8">
                <div class="flex h-16 items-center justify-between">
                    <div class="flex items-center">
                        <h1 class="text-xl font-semibold text-gray-900">
                            {{ config('app.name', 'Laravel') }}
                        </h1>
                    </div>
                    <div class="flex items-center gap-4">
                        <span class="text-sm text-gray-700">
                            {{ $user->name ?? $user->email }}
                        </span>
                        <form method="POST" action="{{ route('auth.logout') }}">
                            @csrf
                            <x-auth-block::button type="submit" variant="secondary">
                                Cerrar Sesión
                            </x-auth-block::button>
                        </form>
                    </div>
                </div>
            </div>
        </nav>

        <!-- Main Content -->
        <main class="mx-auto max-w-7xl px-4 py-12 sm:px-6 lg:px-8">
            <div class="rounded-lg bg-white px-6 py-8 shadow-sm ring-1 ring-gray-200">
                <!-- Welcome Message -->
                <div class="text-center">
                    <div class="mx-auto flex h-16 w-16 items-center justify-center rounded-full bg-gray-100">
                        <svg class="h-8 w-8 text-gray-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z" />
                        </svg>
                    </div>
                    <h2 class="mt-4 text-2xl font-bold text-gray-900">
                        ¡Bienvenido, {{ $user->name ?? $user->email }}!
                    </h2>
                    <p class="mt-2 text-gray-600">
                        Has iniciado sesión correctamente en el sistema.
                    </p>
                </div>

                <!-- User Info Card -->
                <div class="mt-8 border-t border-gray-200 pt-8">
                    <dl class="grid grid-cols-1 gap-6 sm:grid-cols-2">
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Correo Electrónico</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ $user->email }}</dd>
                        </div>
                        @if($user->name)
                            <div>
                                <dt class="text-sm font-medium text-gray-500">Nombre</dt>
                                <dd class="mt-1 text-sm text-gray-900">{{ $user->name }}</dd>
                            </div>
                        @endif
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Sesión Iniciada</dt>
                            <dd class="mt-1 text-sm text-gray-900">{{ now()->format('d/m/Y H:i') }}</dd>
                        </div>
                    </dl>
                </div>

                <!-- Info Box -->
                <div class="mt-8 rounded-lg bg-gray-50 px-4 py-3">
                    <p class="text-sm text-gray-600">
                        <strong>Nota:</strong> Este es un Authentication Block básico. 
                        Puedes extender esta vista con tus propias funcionalidades según tus necesidades.
                    </p>
                </div>
            </div>
        </main>
    </div>
</x-auth-block::layout>
