@props([
    'name',
    'type' => 'text',
    'id' => null,
    'value' => null,
    'placeholder' => null,
    'error' => null,
    'autocomplete' => null,
])

@php
    $id = $id ?? $name;
    $hasError = $error || $errors->has($name);
    $autocompleteValue = $autocomplete ?? match($type) {
        'email' => 'email',
        'password' => 'current-password',
        default => null,
    };
@endphp

<div>
    <input
        type="{{ $type }}"
        name="{{ $name }}"
        id="{{ $id }}"
        value="{{ old($name, $value) }}"
        placeholder="{{ $placeholder }}"
        @if($autocompleteValue) autocomplete="{{ $autocompleteValue }}" @endif
        aria-invalid="{{ $hasError ? 'true' : 'false' }}"
        aria-describedby="{{ $hasError ? $id.'-error' : '' }}"
        @if($hasError)
            class="block w-full rounded-lg border border-red-300 bg-red-50 px-4 py-3 text-gray-900 placeholder-gray-500 focus:border-red-500 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-0 transition-colors"
        @else
            class="block w-full rounded-lg border border-gray-300 bg-white px-4 py-3 text-gray-900 placeholder-gray-500 focus:border-gray-500 focus:outline-none focus:ring-2 focus:ring-gray-500 focus:ring-offset-0 transition-colors"
        @endif
        {{ $attributes }}
    >
    @if($error || $errors->has($name))
        <p id="{{ $id }}-error" class="mt-1.5 flex items-center gap-1.5 text-sm font-medium text-red-600" role="alert">
            <svg class="h-4 w-4 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd" />
            </svg>
            <span>{{ $error ?? $errors->first($name) }}</span>
        </p>
    @endif
</div>
