@props([
    'type' => 'submit',
    'variant' => 'primary',
    'fullWidth' => false,
])

@php
    $baseClasses = 'inline-flex items-center justify-center rounded-lg px-6 py-3 text-sm font-medium transition-colors focus:outline-none focus:ring-2 focus:ring-offset-2 disabled:opacity-50 disabled:cursor-not-allowed';
    
    $variantClasses = match($variant) {
        'primary' => 'bg-gray-900 text-white hover:bg-gray-800 focus:ring-gray-500',
        'secondary' => 'bg-gray-200 text-gray-900 hover:bg-gray-300 focus:ring-gray-500',
        'danger' => 'bg-red-600 text-white hover:bg-red-700 focus:ring-red-500',
        default => 'bg-gray-900 text-white hover:bg-gray-800 focus:ring-gray-500',
    };
    
    $widthClasses = $fullWidth ? 'w-full' : '';
    
    $classes = trim("{$baseClasses} {$variantClasses} {$widthClasses}");
@endphp

<button type="{{ $type }}" {{ $attributes->merge(['class' => $classes]) }}>
    {{ $slot }}
</button>
