@props([
    'type' => 'error',
    'message' => null,
])

@php
    $typeClasses = match($type) {
        'error' => 'bg-red-50 border-red-200 text-red-800',
        'success' => 'bg-green-50 border-green-200 text-green-800',
        'warning' => 'bg-yellow-50 border-yellow-200 text-yellow-800',
        'info' => 'bg-blue-50 border-blue-200 text-blue-800',
        default => 'bg-red-50 border-red-200 text-red-800',
    };
    
    $iconClasses = match($type) {
        'error' => 'text-red-400',
        'success' => 'text-green-400',
        'warning' => 'text-yellow-400',
        'info' => 'text-blue-400',
        default => 'text-red-400',
    };
    
    $icon = match($type) {
        'error' => 'M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z',
        'success' => 'M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z',
        'warning' => 'M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z',
        'info' => 'M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z',
        default => 'M10 14l2-2m0 0l2-2m-2 2l-2-2m2 2l2 2m7-2a9 9 0 11-18 0 9 9 0 0118 0z',
    };
@endphp

@if($message || $slot->isNotEmpty())
    <div class="rounded-lg border p-4 {{ $typeClasses }}">
        <div class="flex">
            <div class="flex-shrink-0">
                <svg class="h-5 w-5 {{ $iconClasses }}" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="{{ $icon }}" />
                </svg>
            </div>
            <div class="ml-3 flex-1">
                <p class="text-sm font-medium">
                    @if($message)
                        {{ $message }}
                    @else
                        {{ $slot }}
                    @endif
                </p>
            </div>
        </div>
    </div>
@endif
