<?php

namespace App\Blocks\Auth\Views\Components;

use Illuminate\View\Component;
use Illuminate\View\View;

class Input extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public string $name,
        public string $type = 'text',
        public ?string $id = null,
        public ?string $value = null,
        public ?string $placeholder = null,
        public ?string $error = null,
        public ?string $autocomplete = null,
    ) {
        $this->id = $id ?? $name;
    }

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View
    {
        return view('auth-block::components.input');
    }
}
