<?php

namespace App\Blocks\Auth\Services;

use App\Blocks\Auth\Requests\LoginRequest;
use App\Blocks\Auth\Requests\RegisterRequest;
use App\Models\User;
use Illuminate\Support\Facades\Auth;

class AuthService
{
    /**
     * Attempt to authenticate a user.
     *
     * @param  \App\Blocks\Auth\Requests\LoginRequest  $request
     * @return void
     */
    public function login(LoginRequest $request): void
    {
        $request->authenticate();

        $request->session()->regenerate();
    }

    /**
     * Register a new user.
     *
     * @param  \App\Blocks\Auth\Requests\RegisterRequest  $request
     * @return \App\Models\User
     */
    public function register(RegisterRequest $request): User
    {
        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => $request->password,
        ]);

        Auth::login($user);

        $request->session()->regenerate();

        return $user;
    }

    /**
     * Log the user out of the application.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return void
     */
    public function logout($request): void
    {
        Auth::logout();

        $request->session()->invalidate();
        $request->session()->regenerateToken();
    }
}
