# Guía de Instalación - Authentication Block

## 📦 Contenido del Paquete

Este paquete contiene un bloque de autenticación completo para Laravel 12 que incluye:

- Sistema de login
- Sistema de registro
- Validación robusta
- Componentes Blade reutilizables
- Dashboard básico
- Rate limiting
- Diseño moderno con Tailwind CSS

## 🚀 Instalación Rápida

### Paso 1: Extraer el contenido

Extrae el contenido del archivo ZIP en tu proyecto Laravel. La carpeta `app/Blocks/Auth/` debe quedar en la raíz de tu proyecto Laravel.

### Paso 2: Registrar el Service Provider

Abre el archivo `bootstrap/providers.php` y añade el Service Provider del bloque:

```php
<?php

return [
    App\Providers\AppServiceProvider::class,
    App\Blocks\Auth\AuthServiceProvider::class, // ← Añadir esta línea
];
```

### Paso 3: Verificar configuración

Asegúrate de que tu archivo `config/auth.php` tenga la configuración estándar:

```php
'guards' => [
    'web' => [
        'driver' => 'session',
        'provider' => 'users',
    ],
],

'providers' => [
    'users' => [
        'driver' => 'eloquent',
        'model' => App\Models\User::class,
    ],
],
```

### Paso 4: Verificar Tailwind CSS

Asegúrate de que Tailwind CSS esté configurado en tu proyecto. El bloque usa clases estándar de Tailwind sin plugins externos.

### Paso 5: Limpiar caché (opcional)

```bash
php artisan config:clear
php artisan view:clear
php artisan route:clear
```

## ✅ Verificación

Una vez instalado, deberías poder acceder a:

- `http://tu-dominio.test/auth/login` - Formulario de login
- `http://tu-dominio.test/auth/register` - Formulario de registro
- `http://tu-dominio.test/auth/dashboard` - Dashboard (requiere autenticación)

## 📋 Requisitos Previos

- Laravel 12.x
- PHP 8.3 o superior
- Tailwind CSS configurado
- Tabla `users` existente en la base de datos

## 🆘 Solución de Problemas

### Error: "Class not found"
- Ejecuta: `composer dump-autoload`

### Error: "Route not found"
- Verifica que el Service Provider esté registrado en `bootstrap/providers.php`
- Limpia las rutas: `php artisan route:clear`

### Los estilos no se ven
- Verifica que Tailwind CSS esté compilado: `npm run build` o `npm run dev`
- Asegúrate de que `@vite` esté funcionando correctamente

## 📚 Documentación Completa

Consulta el archivo `README.md` para documentación completa, ejemplos de uso y personalización.

## 📄 Licencia y Términos de Uso

### Licencia de Uso

Este bloque de autenticación está diseñado para ser vendido como script individual. Al adquirir este producto, obtienes una licencia de uso personal o comercial para un solo proyecto.

### Restricciones Importantes

**❌ PROHIBIDO:**
- Revender, redistribuir o compartir este código
- Incluir este código en otros productos o scripts para venta
- Modificar y vender como producto propio
- Compartir el código con terceros sin autorización
- Usar en múltiples proyectos sin licencias adicionales

**✅ PERMITIDO:**
- Usar en un proyecto personal o comercial
- Modificar el código para tus necesidades
- Integrar en aplicaciones cliente
- Usar como base para proyectos propios (sin revender el código)

### Uso Comercial

Puedes usar este bloque en proyectos comerciales y aplicaciones cliente sin restricciones, siempre que no revendas o redistribuyas el código fuente.

### Soporte

**Importante sobre Soporte:**

- **Scripts de Pago:** Incluyen soporte según los términos de tu compra. Consulta los detalles de soporte en tu plataforma de compra.
- **Scripts Gratuitos:** NO incluyen soporte técnico. El código se proporciona "tal cual" sin garantías ni asistencia.
- **Licencias y Términos:** Para consultas sobre licencias o términos de uso, consulta los términos de licencia de tu compra o el archivo `LICENSE.txt` incluido.

**Al usar este código, aceptas estos términos de licencia y las condiciones de soporte.**

---

**Desarrollado para Laravel 12** | Authentication Block v1.0
