<?php

namespace App\Blocks\Auth\Controllers;

use App\Blocks\Auth\Requests\LoginRequest;
use App\Blocks\Auth\Requests\RegisterRequest;
use App\Blocks\Auth\Services\AuthService;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\View\View;

class AuthController
{
    /**
     * Create a new controller instance.
     */
    public function __construct(
        protected AuthService $authService
    ) {
        //
    }

    /**
     * Show the login form.
     */
    public function showLoginForm(): View
    {
        return view('auth-block::login');
    }

    /**
     * Handle a login request to the application.
     */
    public function login(LoginRequest $request): RedirectResponse
    {
        $this->authService->login($request);

        return redirect()->intended(route('auth.dashboard'));
    }

    /**
     * Show the registration form.
     */
    public function showRegisterForm(): View
    {
        return view('auth-block::register');
    }

    /**
     * Handle a registration request to the application.
     */
    public function register(RegisterRequest $request): RedirectResponse
    {
        $this->authService->register($request);

        return redirect()->route('auth.dashboard');
    }

    /**
     * Log the user out of the application.
     */
    public function logout(Request $request): RedirectResponse
    {
        $this->authService->logout($request);

        return redirect()->route('auth.login');
    }

    /**
     * Show the dashboard after successful login.
     */
    public function dashboard(): View
    {
        return view('auth-block::dashboard', [
            'user' => Auth::user(),
        ]);
    }
}
