# Changelog - Authentication Block

Todos los cambios notables de este proyecto serán documentados en este archivo.

## [1.0.0] - 2024-12-01

### Agregado
- Sistema de login completo con validación
- Sistema de registro con validación robusta
- Componentes Blade reutilizables (Input, Button, Layout, Alert)
- Vista de dashboard básica
- Rate limiting para protección contra ataques de fuerza bruta
- Validación de formularios con mensajes personalizados en español
- Diseño moderno y profesional con Tailwind CSS
- Arquitectura limpia (Controllers, Services, Requests)
- Service Provider aislado del bloque
- Rutas con prefijo `/auth`
- Documentación completa (README, INSTALLATION)
- Soporte para autocompletado en formularios
- Accesibilidad mejorada (ARIA attributes)

### Características de Seguridad
- Rate limiting: 5 intentos por minuto por IP
- Validación del lado del servidor (sin validación HTML)
- Regeneración de sesión tras login exitoso
- Validación de contraseña robusta (mínimo 8 caracteres, letras, números, mayúsculas/minúsculas)
- Validación de email con verificación DNS y RFC
- Protección CSRF en todos los formularios

### Diseño
- Diseño limpio y profesional
- Responsive design
- Estados de error visuales
- Componentes reutilizables
- Tailwind CSS estándar (sin plugins externos)

---

**Versión inicial del Authentication Block para Laravel 12**
