<?php

namespace App\Blocks\Auth;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // Register block routes
        Route::middleware('web')
            ->prefix('auth')
            ->group(base_path('app/Blocks/Auth/routes.php'));

        // Register block views
        $this->loadViewsFrom(
            base_path('app/Blocks/Auth/Views'),
            'auth-block'
        );

        // Register Blade components
        $this->loadViewComponentsAs('auth-block', [
            'layout' => \App\Blocks\Auth\Views\Components\Layout::class,
            'input' => \App\Blocks\Auth\Views\Components\Input::class,
            'button' => \App\Blocks\Auth\Views\Components\Button::class,
            'alert' => \App\Blocks\Auth\Views\Components\Alert::class,
        ]);
    }
}
