@props([
    'datetime',
    'format' => 'human',
    'showTooltip' => true,
])

@php
    use App\Blocks\Timestamps\Services\TimestampService;

    $formattedText = match($format) {
        'human' => TimestampService::humanDiff($datetime),
        'short' => TimestampService::short($datetime),
        'long' => TimestampService::long($datetime),
        'with-label' => TimestampService::withLabel($datetime),
        'time' => TimestampService::time($datetime),
        'date' => TimestampService::date($datetime),
        default => TimestampService::humanDiff($datetime),
    };

    $isoDate = TimestampService::iso($datetime);
    $tooltipText = $format === 'human' 
        ? TimestampService::long($datetime) 
        : TimestampService::humanDiff($datetime);
@endphp

<time 
    datetime="{{ $isoDate }}"
    @if($showTooltip)
        title="{{ $tooltipText }}"
    @endif
    class="text-[#706f6c] dark:text-[#A1A09A] {{ $attributes->get('class') }}"
    {{ $attributes->except('class') }}
>
    {{ $formattedText }}
</time>
