<?php

namespace App\Blocks\Timestamps\Components;

use Illuminate\View\Component;
use Illuminate\View\View;

class Timestamp extends Component
{
    /**
     * Create a new component instance.
     */
    public function __construct(
        public $datetime,
        public string $format = 'human',
        public bool $showTooltip = true,
    ) {}

    /**
     * Get the view / contents that represent the component.
     */
    public function render(): View
    {
        return view('timestamp-block::components.timestamp');
    }
}
